// SPDX-License-Identifier: GPL-2.0
#include <stdio.h>
#include <bpf/libbpf.h>
#include "page_pool_modify.skel.h"

int main(int argc, char **argv)
{
    struct page_pool_modify_bpf *skel;
    int err;

    skel = page_pool_modify_bpf__open_and_load();
    if (!skel) {
        fprintf(stderr, "Failed to open and load BPF skeleton\n");
        return 1;
    }

    err = page_pool_modify_bpf__attach(skel);
    if (err) {
        fprintf(stderr, "Failed to attach BPF program\n");
        page_pool_modify_bpf__destroy(skel);
        return 1;
    }

    printf("BPF program attached successfully!\n");
    printf("Exiting userspace loader - BPF program remains attached.\n");
    
    /* Intentionally NOT calling page_pool_modify_bpf__destroy(skel) */
    /* The BPF program will stay loaded until: */
    /* 1. System reboot */
    /* 2. Manual detachment via bpftool */
    /* 3. Another program detaches it */
    
    return 0;
}
